/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xladata.h
 *       analyzer control functions
 * -----------------------------------------------------------------*/

#ifndef XLADATA_H_INCLUDED
#define XLADATA_H_INCLUDED

#include <xladefs.h>
#include <xtrcdefs.h>
#include <xhostdef.h>

#ifdef __cplusplus
extern "C" {
#endif

/* ---------------------------------------------------------------
 * Trace properties
 * --------------------------------------------------------------- */

CLI bx_errtype EXPORT BestXTraceWrite(            /* @tracewrite */ 
  bx_handletype    handle,
  bx_tracetype     prop,                        
  bx_int32         val                             
);

CLI bx_errtype EXPORT BestXTraceRead(            /* @traceread */ 
  bx_handletype    handle,
  bx_tracetype     prop,                   
  bx_int32         *val                        /* #RETURN  "0x%08lx" */
);

CLI  bx_errtype EXPORT BestXTraceDefaultWrite(   /* @tracedefwrite */ 
  bx_handletype    handle
);

/* ---------------------------------------------------------------
 * Trace actions
 * --------------------------------------------------------------- */

CLI  bx_errtype EXPORT BestXTraceRun(               /* @tracerun */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXTraceStop(              /* @tracestop */
  bx_handletype handle
);

/* ---------------------------------------------------------------
 * Trace misc
 * --------------------------------------------------------------- */
#ifndef SWIG
CLI  bx_errtype EXPORT BestXTraceDataRead(       /* @tracedataread */
  bx_handletype handle,
  bx_int32 offset,                           
  bx_int32 num,                         
  bx_int32  *data /* #RETURN datalist(data,num) [num * 7] */
);
#else
/* chris: 
   Do not change the parameter names !
   SWIG relies on that 
*/
bx_errtype EXPORT BestXTraceDataRead(      
  bx_handletype handle,
  bx_int32 offset,                           
  bx_int32 NumLinesFor32BitDataOut,                         
  bx_int32  *DataFor32BitDataOut 
);
#endif

#ifndef SWIG
CLI bx_errtype EXPORT BestXTraceBitPosGet(          /* @tracebitposget */
  bx_handletype handle,
  bx_signaltype signal, 
  bx_int32 *position,   /* #RETURN "Pos: %lu\n" */
  bx_int32 *length      /* #RETURN "Len: %lu"   */
);
#endif

/* This is for TCL/SWIG */
bx_errtype EXPORT BestXTraceBitPositionGet(          
  bx_handletype handle,
  bx_signaltype signal, 
  bx_int32 *position
);

/* This is for TCL/SWIG */
bx_errtype EXPORT BestXTraceBitLengthGet(          
  bx_handletype handle,
  bx_signaltype signal, 
  bx_int32 *length
);


CLI bx_errtype EXPORT BestXTraceBytePerLineGet(     /* @tracebyteperlineget */
  bx_handletype handle,
  bx_int32 * bytes_per_line /* #RETURN "%lu" */
);

CLI bx_errtype EXPORT BestXTraceDump(     /* @tracedump */
  bx_handletype handle,                   
  bx_charptrtype file                     /* $"c:\\tracedump.wfm" */
);

CLI bx_errtype EXPORT BestXTraceMemorySize ( /* @tracememorysize */
  bx_handletype handle,
  bx_int32 * pSize                           /* #RETURN "%#lx" */
  );

#define BX_WFM_STANDARD      0
#define BX_WFM_COMPRESSED_1  1
#define BX_WFM_THRESHOLD     0x3490
#define BX_WFM_COMP_1_STRING  "COMP_1"

bx_errtype EXPORT BestXTraceDataReadAdv(
  bx_handletype handle,
  bx_int32 offset,
  bx_int32 num,
  bx_int32 * data,
  bx_bool doInit,
  bx_int32ptr pTraceAddr
  );

bx_errtype EXPORT BestXTraceDumpAdv (
  bx_handletype handle,
  bx_charptrtype filename,
  bx_int32 pretrig,
  bx_int32 posttrig,
  int (*cb) (int),
  int modebit,
  int storemode
);

/* Read raw data from tracememory */
bx_errtype EXPORT BestXTraceRawRead(
    bx_handletype handle,
    bx_int32 startAddr,
    bx_int16ptr data,   
    bx_int32 numWords,        
    bx_int32 mode
);

/* Write raw data to tracememory */
bx_errtype EXPORT BestXTraceRawWrite(
    bx_handletype handle,
    bx_int32 startAddr,
    bx_int16ptr data,   
    bx_int32 numWords,        
    bx_int32 mode
);

/* Fill tracememory with raw data pattern */
CLI bx_errtype EXPORT BestXTraceRawPatternFill(  /* @tracerawpatternfill */
  bx_handletype handle,
  bx_int32 addr,         /* $0 */
  bx_int32 lines,
  bx_int16 val1,         /* $0 */
  bx_int16 val2,         /* $0 */
  bx_int16 mode,         /* $1 */
  bx_dmempatttype patt   /* $0 */
);

/* Dumps raw tracedata to a file */
CLI bx_errtype EXPORT BestXTraceRawDump( /* @tracerawdump */
  bx_handletype handle,
  bx_int32 addr,  /* $0 */ 
  bx_int32 lines, 
  bx_int16 mode,  /* $1 */
  bx_charptrtype file /* $"c:\\tracerawdump.bin" */
);




#ifdef __cplusplus
}
#endif

#endif

